#! /bin/sh

SERVER_DEP_ROOT="/opt/TrendMicro/Pixiebob/Server_dep/"
SERVER_ROOT="/opt/TrendMicro/Pixiebob/Server/"
POST_INSTALL_LOG="${SERVER_ROOT}logs/post_install_server_dep.log"
INIT_FLAG="${SERVER_DEP_ROOT}init.flag"
MIGRATE_FLAG="${SERVER_DEP_ROOT}migrate.flag"

############################################################
##               Install Pip resources                    ##
############################################################

install_pip_source() {

    # Export postgresql path to environment for psycopg2 installation
    export PATH=$PATH:/usr/pgsql-9.6/bin/

    pip install --upgrade --force-reinstall -r ${SERVER_DEP_ROOT}requirements.txt --no-index --find-links file://${SERVER_DEP_ROOT}pip_source/ >> ${POST_INSTALL_LOG} 2>&1

    # Install pycurl with extra install option
    pip install pycurl --no-index --upgrade --force-reinstall --find-links file://${SERVER_DEP_ROOT}pip_source/ --install-option="--with-openssl" >> ${POST_INSTALL_LOG} 2>&1

    # Install open-vm-tools if in VMWare environment
    if [ "$(dmidecode -s system-product-name | grep -i vmware)" != "" ]; then
        echo "[`date`] VMWare environment detected, install open-vm-tools" >> ${POST_INSTALL_LOG} 2>&1
        rm -f /var/lib/rpm/.rpm.lock
        rpm -Uvh --force ${SERVER_DEP_ROOT}centos_rpms/open-vm-tools*.rpm >> ${POST_INSTALL_LOG} 2>&1
        systemctl start vmtoolsd.service
    fi

}

uninstall_pip_packages() {
    # pycrypto was replaced with pycryptodome
    pip uninstall -y pycrypto >> ${POST_INSTALL_LOG} 2>&1
    pip uninstall -y pycryptodome >> ${POST_INSTALL_LOG} 2>&1
    pip uninstall -y zipstream >> ${POST_INSTALL_LOG} 2>&1
    pip uninstall -y pysmbc >> ${POST_INSTALL_LOG} 2>&1
}

mkdir -p "${SERVER_ROOT}logs/"
# Main logic
if [ "$(stat -c %d:%i /)" == "$(stat -c %d:%i /proc/1/root/.)" ]; then
    if [ ! -f ${INIT_FLAG} ]; then
        echo "[`date`] Installed manually, launch data initialization script." >> ${POST_INSTALL_LOG} 2>&1
        install_pip_source
        touch ${INIT_FLAG}
    elif [ -f ${MIGRATE_FLAG} ]; then
        echo "[`date`] Migrate case, remove obsolete python packages." >> ${POST_INSTALL_LOG} 2>&1
        uninstall_pip_packages
        echo "[`date`] Migrate case, launch data initialization script." >> ${POST_INSTALL_LOG} 2>&1
        install_pip_source
        /usr/bin/rm -f ${MIGRATE_FLAG}
    else
        echo "[`date`] Data already initialized, skip." >> ${POST_INSTALL_LOG} 2>&1
    fi
else
    echo "[`date`] Installed from kickstart, skip launching data initialization script." >> ${POST_INSTALL_LOG} 2>&1

fi



